#ifndef __CCLINK_SLAVE_ERROR_H
#define __CCLINK_SLAVE_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// CC-Link Slave
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_CCLINK_SLAVE_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_CCLINK_SLAVE_COMMAND_INVALID ((TLR_RESULT)0xC06A0001L)

//
// MessageId: TLR_E_CCLINK_SLAVE_WATCHDOG_FAIL
//
// MessageText:
//
//  Watchdog failure detected.
//
#define TLR_E_CCLINK_SLAVE_WATCHDOG_FAIL ((TLR_RESULT)0xC06A0002L)

//
// MessageId: TLR_I_CCLINK_SLAVE_ALREADY_IN_STATE
//
// MessageText:
//
//  Slave is already in requested state.
//
#define TLR_I_CCLINK_SLAVE_ALREADY_IN_STATE ((TLR_RESULT)0x406A0003L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PACKET_LENGTH
//
// MessageText:
//
//  Invalid length in packet.
//
#define TLR_E_CCLINK_SLAVE_PACKET_LENGTH ((TLR_RESULT)0xC06A0004L)

//
// MessageId: TLR_E_CCLINK_SLAVE_DATA_COUNT
//
// MessageText:
//
//  Invalid data count.
//
#define TLR_E_CCLINK_SLAVE_DATA_COUNT    ((TLR_RESULT)0xC06A0005L)

//
// MessageId: TLR_E_CCLINK_SLAVE_DATA_OFFSET
//
// MessageText:
//
//  Invalid data offset.
//
#define TLR_E_CCLINK_SLAVE_DATA_OFFSET   ((TLR_RESULT)0xC06A0006L)

//
// MessageId: TLR_E_CCLINK_SLAVE_INIT_BUFFER
//
// MessageText:
//
//  Initialization of buffer failed.
//
#define TLR_E_CCLINK_SLAVE_INIT_BUFFER   ((TLR_RESULT)0xC06A0007L)

//
// MessageId: TLR_E_CCLINK_SLAVE_INVALID_STATE
//
// MessageText:
//
//  Command is not allowed in current state.
//
#define TLR_E_CCLINK_SLAVE_INVALID_STATE ((TLR_RESULT)0xC06A0008L)

//
// MessageId: TLR_E_CCLINK_SLAVE_MODE
//
// MessageText:
//
//  Invalid mode in command.
//
#define TLR_E_CCLINK_SLAVE_MODE          ((TLR_RESULT)0xC06A0009L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_BAUDRATE
//
// MessageText:
//
//  Invalid Baudrate.
//
#define TLR_E_CCLINK_SLAVE_PARAM_BAUDRATE ((TLR_RESULT)0xC06A000AL)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_STATION_ADDR
//
// MessageText:
//
//  Invalid station address for CC-Link Slave.
//
#define TLR_E_CCLINK_SLAVE_PARAM_STATION_ADDR ((TLR_RESULT)0xC06A000BL)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_NO_STATIONS
//
// MessageText:
//
//  Invalid parameter for number of stations.
//
#define TLR_E_CCLINK_SLAVE_PARAM_NO_STATIONS ((TLR_RESULT)0xC06A000CL)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_VENDOR_CODE
//
// MessageText:
//
//  Invalid parameter for vendor code.
//
#define TLR_E_CCLINK_SLAVE_PARAM_VENDOR_CODE ((TLR_RESULT)0xC06A000DL)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_MODEL_CODE
//
// MessageText:
//
//  Invalid parameter for model code.
//
#define TLR_E_CCLINK_SLAVE_PARAM_MODEL_CODE ((TLR_RESULT)0xC06A000EL)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_SW_VERSION
//
// MessageText:
//
//  Invalid parameter for software version.
//
#define TLR_E_CCLINK_SLAVE_PARAM_SW_VERSION ((TLR_RESULT)0xC06A000FL)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_MODEL_TYPE
//
// MessageText:
//
//  Invalid parameter for model type.
//
#define TLR_E_CCLINK_SLAVE_PARAM_MODEL_TYPE ((TLR_RESULT)0xC06A0010L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_STATION_TYPE
//
// MessageText:
//
//  Invalid parameter for station type.
//
#define TLR_E_CCLINK_SLAVE_PARAM_STATION_TYPE ((TLR_RESULT)0xC06A0011L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_CYCLETIME
//
// MessageText:
//
//  Invalid parameter for cycle time.
//
#define TLR_E_CCLINK_SLAVE_PARAM_CYCLETIME ((TLR_RESULT)0xC06A0012L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_XC_INSTANCE
//
// MessageText:
//
//  Invalid parameter for XC-Instance.
//
#define TLR_E_CCLINK_SLAVE_PARAM_XC_INSTANCE ((TLR_RESULT)0xC06A0013L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_STATION_ADDR_WITH_NO_STATIONS
//
// MessageText:
//
//  Invalid parameter for station address in combination with number of stations.
//
#define TLR_E_CCLINK_SLAVE_PARAM_STATION_ADDR_WITH_NO_STATIONS ((TLR_RESULT)0xC06A0014L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_CCLINK_VERSION
//
// MessageText:
//
//  Invalid parameter for CC-Link version.
//
#define TLR_E_CCLINK_SLAVE_PARAM_CCLINK_VERSION ((TLR_RESULT)0xC06A0015L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_EXTENSION_CYCLE
//
// MessageText:
//
//  Invalid parameter for extension cycle.
//
#define TLR_E_CCLINK_SLAVE_PARAM_EXTENSION_CYCLE ((TLR_RESULT)0xC06A0016L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_STATION_TYPE_WITH_CCLINK_VERSION
//
// MessageText:
//
//  Invalid parameter for station type in combination with CC-Link version.
//
#define TLR_E_CCLINK_SLAVE_PARAM_STATION_TYPE_WITH_CCLINK_VERSION ((TLR_RESULT)0xC06A0017L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_QUEUE_ELEMENT
//
// MessageText:
//
//  Invalid parameter for number of queue elements.
//
#define TLR_E_CCLINK_SLAVE_PARAM_QUEUE_ELEMENT ((TLR_RESULT)0xC06A0018L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_POOL_ELEMENT
//
// MessageText:
//
//  Invalid parameter for number of pool elements.
//
#define TLR_E_CCLINK_SLAVE_PARAM_POOL_ELEMENT ((TLR_RESULT)0xC06A0019L)

//
// MessageId: TLR_E_CCLINK_SLAVE_PARAM_IO_TYPES_POINTS
//
// MessageText:
//
//  Invalid parameter for number of I/O types and I/O points.
//
#define TLR_E_CCLINK_SLAVE_PARAM_IO_TYPES_POINTS ((TLR_RESULT)0xC06A001AL)




#endif  //__CCLINK_SLAVE_ERROR_H

